; ===============================================================
; TIOS character mapping
; ===============================================================

; NOTA BENE: Invisible symbols below could well be a result of
; your machine not supporting some of the more exotic Unicode
; characters. Just ignore them.

.asciimap '∫', $08 ; Integral sign
.asciimap '×', $09 ; Multiplication sign
.asciimap '³', $0E ; Superscipt 3
.asciimap '√', $10 ; Square root
.asciimap '²', $12 ; Superscript 2
.asciimap '°', $14 ; Degree sign

.asciimap '≤', $17 ; Less-than or equal to
.asciimap '≠', $18 ; Inequality sign
.asciimap '≥', $19 ; More-than or equal to

.asciimap '→', $1C ; Right arrow
.asciimap '↑', $1E ; Up arrow
.asciimap '↓', $1F ; Down arrow

.asciimap '⁴', $24 ; Superscript 4

.asciimap 'θ', $5B ; Greek small Theta

.asciimap 'Á', $8A ; Latin capital A with acute
.asciimap 'À', $8B ; Latin capital A with grave
.asciimap 'Â', $8C ; Latin capital A with circumflex
.asciimap 'Ä', $8D ; Latin capital A with diaeresis

.asciimap 'á', $8E ; Latin small A with acute
.asciimap 'à', $8F ; Latin small A with grave
.asciimap 'â', $90 ; Latin small A with circumflex
.asciimap 'ä', $91 ; Latin small A with diaeresis

.asciimap 'É', $92 ; Latin capital E with acute
.asciimap 'È', $93 ; Latin capital E with grave
.asciimap 'Ê', $94 ; Latin capital E with circumflex
.asciimap 'Ë', $95 ; Latin capital E with diaeresis

.asciimap 'é', $96 ; Latin small E with acute
.asciimap 'è', $97 ; Latin small E with grave
.asciimap 'ê', $98 ; Latin small E with circumflex
.asciimap 'ë', $99 ; Latin small E with diaeresis

.asciimap 'Í', $9A ; Latin capital I with acute
.asciimap 'Ì', $9B ; Latin capital I with grave
.asciimap 'Î', $9C ; Latin capital I with circumflex
.asciimap 'Ï', $9D ; Latin capital I with diaeresis

.asciimap 'í', $9E ; Latin small I with acute
.asciimap 'ì', $9F ; Latin small I with grave
.asciimap 'î', $A0 ; Latin small I with circumflex
.asciimap 'ï', $A1 ; Latin small I with diaeresis

.asciimap 'Ó', $A2 ; Latin capital O with acute
.asciimap 'Ò', $A3 ; Latin capital O with grave
.asciimap 'Ô', $A4 ; Latin capital O with circumflex
.asciimap 'Ö', $A5 ; Latin capital O with diaeresis

.asciimap 'ó', $A6 ; Latin small O with acute
.asciimap 'ò', $A7 ; Latin small O with grave
.asciimap 'ô', $A8 ; Latin small O with circumflex
.asciimap 'ö', $A9 ; Latin small O with diaeresis

.asciimap 'Ú', $AA ; Latin capital U with acute
.asciimap 'Ù', $AB ; Latin capital U with grave
.asciimap 'Û', $AC ; Latin capital U with circumflex
.asciimap 'Ü', $AD ; Latin capital U with diaeresis

.asciimap 'ú', $AE ; Latin small U with acute
.asciimap 'ù', $AF ; Latin small U with grave
.asciimap 'û', $B0 ; Latin small U with circumflex
.asciimap 'ü', $B1 ; Latin small U with diaeresis

.asciimap 'Ç', $B2 ; Latin capital C with cedilla
.asciimap 'ç', $B3 ; Latin small C with cedilla
.asciimap 'Ñ', $B4 ; Latin capital N with tilde
.asciimap 'ñ', $B5 ; Latin small N with tilde

.asciimap '´', $B6 ; Acute
.asciimap '`', $B7 ; Grave
.asciimap '¨', $B8 ; Diaeresis

.asciimap '¿', $B9 ; Inverted question mark
.asciimap '¡', $B9 ; Inverted exclamation mark


.asciimap 'α', $BB ; Greek small Alpha
.asciimap 'β', $BC ; Greek small Beta
.asciimap 'γ', $BD ; Greek small Gamma
.asciimap 'Δ', $BE ; Greek capital Delta
.asciimap 'δ', $BF ; Greek small Delta
.asciimap 'ε', $C0 ; Greek small Epsilon
.asciimap '[', $C1 ; Left bracket (see Theta)
.asciimap 'λ', $C2 ; Greek small Lambda
.asciimap 'μ', $C3 ; Greek small Micro
.asciimap 'π', $C4 ; Greek small Pi
.asciimap 'ρ', $C5 ; Greek small Rho
.asciimap 'Σ', $C6 ; Greek capital Sigma
.asciimap 'σ', $C7 ; Greek small Sigma
.asciimap 'τ', $C8 ; Greek small Tau
.asciimap 'φ', $C9 ; Greek small Phi
.asciimap 'Ω', $CA ; Greek capital Omega

.asciimap '…', $CE ; Ellipsis

.asciimap 'χ', $D9 ; Greek small Chi
